#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                                     Order 51.mq4 |
//|                                                                  |
//|                                                                  |
//|                                        Converted by Mql2Mq4 v1.0 |
//|                                            http://yousky.free.fr |
//|                                    Copyright  2006, Yousky Soft |
//+------------------------------------------------------------------+

#property copyright ""
#property link      " http:1"


//+------------------------------------------------------------------+
//| Common External variables                                        |
//+------------------------------------------------------------------+
extern double Lots = 1.00;
extern double StopLoss = 0.00;
extern double TakeProfit = 500.00;
extern double TrailingStop = 0.00;

//+------------------------------------------------------------------+
//| External variables                                               |
//+------------------------------------------------------------------+
extern double InitialStopLoss = 25;
extern double StopLossTarget = 15;
extern double BEPPoints = 1;
extern double SLRecountTarget = 10;
extern double Reverce = 0;
extern double DBLReverce = 0;
extern double Slippage = 2;

//+------------------------------------------------------------------+
//| Special Convertion Functions                                     |
//+------------------------------------------------------------------+

int LastTradeTime;

bool MOrderDelete( int ticket )
{
  LastTradeTime = CurTime();
  return ( OrderDelete( ticket ) );
}

bool MOrderModify( int ticket, double price, double stoploss, double takeprofit, datetime expiration, color arrow_color=CLR_NONE)
{
  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
  stoploss = MathRound(stoploss*10000)/10000;
  takeprofit = MathRound(takeprofit*10000)/10000;
  return ( OrderModify( ticket, price, stoploss, takeprofit, expiration, arrow_color) );
}

int MOrderSend( string symbol, int cmd, double volume, double price, int slippage, double stoploss, double takeprofit, string comment="", int magic=0, datetime expiration=0, color arrow_color=CLR_NONE)
{
  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
  stoploss = MathRound(stoploss*10000)/10000;
  takeprofit = MathRound(takeprofit*10000)/10000;
  return ( OrderSend( symbol, cmd, volume, price, slippage, stoploss, takeprofit, comment, magic, expiration, arrow_color ) );
}

int OrderValueTicket(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderTicket());
}

int OrderValueType(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderType());
}

double OrderValueLots(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderLots());
}

double OrderValueOpenPrice(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderOpenPrice());
}

double OrderValueStopLoss(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderStopLoss());
}

double OrderValueTakeProfit(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderTakeProfit());
}

string OrderValueSymbol(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderSymbol());
}

//+------------------------------------------------------------------+
//| End                                                              |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+

int init()
{
   return(0);
}
int start()
{
//+------------------------------------------------------------------+
//| Local variables                                                  |
//+------------------------------------------------------------------+
int counter = 0;
double poslots = 0;
int fo = 0;
double stop = 0;

/*[[
	Name := Order 51
	Link := http:1
	Lots := 1.00
	Stop Loss := 0
	Take Profit := 500
	Trailing Stop := 0
]]*/




/*
// 
if TotalTrades == 0 then Begin
	if C[1]>iMa(10,MODE_SMA,1) then
	SetOrder(OP_BUY, 1, Bid, 3, 0, 0, Red);
	if C[1]<iMa(10,MODE_SMA,1) then
	SetOrder(OP_SELL, 1, Ask, 3, 0, 0, Red);
ENd;
*/
//   
for(counter =1;counter <=OrdersTotal() ;counter ++){ 

	//     
	if( OrderValueSymbol(counter) == Symbol() && OrderValueType(counter) == OP_BUY ) { 	
		// ,     -.
		if( OrderValueStopLoss(counter) ==  0 ) { 
			MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						OrderValueOpenPrice(counter)-InitialStopLoss*Point,
						OrderValueOpenPrice(counter)+TakeProfit*Point,0,Red);
			return(0);//    ,  
		} 
		
		//  ,    -  ,
		//  ,  
		if( Reverce > 0 && OrdersTotal() > 0 && 
		  (OrderValueOpenPrice(counter)-InitialStopLoss*Point) == OrderValueStopLoss(counter) ) { 			
			//     ,      
			poslots = OrderValueLots(counter);
			//     
			stop=0;
			for(fo =1;fo <=OrdersTotal() ;fo ++){ 
				if( OrderValueSymbol(fo) == Symbol() && OrderValueType(fo) == OP_SELLSTOP ) 
					stop=1;		
			} 
			//  ,   
			if( DBLReverce > 0 ) poslots *= 2;
			if( stop == 0 ) { 
				MOrderSend(Symbol(),OP_SELLSTOP, poslots, OrderValueOpenPrice(counter)-InitialStopLoss*Point, Slippage,
						 OrderValueOpenPrice(counter)+TakeProfit*Point,0,"",16384,0, Red);
				return(0);/* ,       */
			} 
		} 
			
		//   ,      
		if( (OrderValueOpenPrice(counter)-InitialStopLoss*Point) == OrderValueStopLoss(counter) &&
		   (Bid - OrderValueOpenPrice(counter)) >= StopLossTarget*Point ) { 
			MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						OrderValueOpenPrice(counter)+BEPPoints*Point,
						OrderValueTakeProfit(counter),0,Red);
			return(0);
		} 
		
		//   /,     
		if( OrderValueStopLoss(counter) >= OrderValueOpenPrice(counter) ) 
			if( (Bid - (SLRecountTarget+StopLossTarget)*Point) >= OrderValueStopLoss(counter) ) { 
				Print("  ");
				MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						Bid - StopLossTarget*Point,
						OrderValueTakeProfit(counter),0,Red);
				return(0);
			} 
		
		//    -     
		if( Reverce > 0 ) { 			
			//     ,      
			for(fo =1;fo <=OrdersTotal() ;fo ++){ 
				if( OrderValueType(fo) == OP_SELLSTOP && OrderValueSymbol(fo) == Symbol() && OrderValueOpenPrice(fo) <= OrderValueStopLoss(counter) &&
				OrderValueOpenPrice(counter)+BEPPoints*Point == OrderValueStopLoss(counter) ) { 
					Print("ModifyOrder");
					MOrderDelete(OrderValueTicket(fo));
					return(0);/* ,       */
				} 
			} 
			
		} 
	} 
		
	//     
	if( OrderValueSymbol(counter) == Symbol() && OrderValueType(counter) == OP_SELL ) { 	
		// ,     -.
		if( OrderValueStopLoss(counter) ==  0 ) { 
			MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						OrderValueOpenPrice(counter)+InitialStopLoss*Point,
						OrderValueOpenPrice(counter)-TakeProfit*Point,0,Red);
			return(0);//    ,  
		} 
		
		//  ,    -  ,
		//  ,  
		if( Reverce > 0 && OrdersTotal() > 0 && 
		  (OrderValueOpenPrice(counter)+InitialStopLoss*Point) == OrderValueStopLoss(counter) ) { 			
			//     ,      
			poslots = OrderValueLots(counter);
			//     
			stop=0;
			for(fo =1;fo <=OrdersTotal() ;fo ++){ 
				if( OrderValueSymbol(fo) == Symbol() && OrderValueType(fo) == OP_BUYSTOP ) 
					stop=1;		
			} 
			//  ,   
			if( DBLReverce > 0 ) poslots *= 2;
			if( stop == 0 ) { 
				MOrderSend(Symbol(),OP_BUYSTOP, poslots, OrderValueOpenPrice(counter)+InitialStopLoss*Point, Slippage,
						 OrderValueOpenPrice(counter)-TakeProfit*Point,0,"",16384,0, Red);
				return(0);/* ,       */
			} 
		} 
			
		//   ,      
		if( (OrderValueOpenPrice(counter)+InitialStopLoss*Point) == OrderValueStopLoss(counter) &&
		   (OrderValueOpenPrice(counter)-Ask) >= StopLossTarget*Point ) { 
			MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						OrderValueOpenPrice(counter)-BEPPoints*Point,
						OrderValueTakeProfit(counter),0,Red);
			return(0);
		} 
		
		//   /,     
		if( OrderValueStopLoss(counter) <= OrderValueOpenPrice(counter) ) 
			if( (Ask + (SLRecountTarget+StopLossTarget)*Point) <= OrderValueStopLoss(counter) ) { 
				Print("  ");
				MOrderModify(OrderValueTicket(counter),OrderValueOpenPrice(counter),
						//  -    
						Ask + StopLossTarget*Point,
						OrderValueTakeProfit(counter),0,Red);
				return(0);
			} 
		
		//    -     
		if( Reverce > 0 ) { 			
			//     ,      
			for(fo =1;fo <=OrdersTotal() ;fo ++){ 
				if( OrderValueType(fo) == OP_BUYSTOP && OrderValueSymbol(fo) == Symbol() && OrderValueOpenPrice(fo) >= OrderValueStopLoss(counter) &&
				   OrderValueOpenPrice(counter)-BEPPoints*Point == OrderValueStopLoss(counter) ) { 
					Print("ModifyOrder");
					MOrderDelete(OrderValueTicket(fo));
					return(0);/* ,       */
				} 
			} 
			
		}
		
	
	}
	
}	
	

	  return(0);
}